<?php
session_start();
require 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    if (empty($email) || empty($password)) {
        $_SESSION['message'] = ["text" => "Visi lauki ir obligāti!", "type" => "error"];
    } else {
        $stmt = $pdo->prepare("SELECT id, username, password_hash FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['message'] = ["text" => "Pieteikšanās veiksmīga!", "type" => "success"];
            header("Location: dashboard.php");
            exit();
        } else {
            $_SESSION['message'] = ["text" => "Nepareizs e-pasts vai parole!", "type" => "error"];
        }
    }
}
?>

<?php include 'header.php'; ?>

<div class="form-container">
    <h2>Pieslēgties</h2>

    <?php include 'messages.php'; ?>

    <form method="POST">
        <label for="email">E-pasts:</label>
        <input type="email" id="email" name="email" required>

        <label for="password">Parole:</label>
        <input type="password" id="password" name="password" required>

        <button type="submit">Pieslēgties</button>
    </form>

    <p>Nav konta? <a href="register.php">Reģistrēties</a></p>
</div>

<?php include 'footer.php'; ?>
